﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Odbc;
using System.Data;
using System.Globalization;
using System.Threading;

namespace PsgServer
{
    class Utils
    {
        public static string Null = "'null'";
        public static Server server;
        public static string NumberDecimalSeparator = ",";      

        public static bool StringEquals(object str1, object str2)
        {
            if (string.IsNullOrEmpty(IsNull(str1, string.Empty)) && string.IsNullOrEmpty(IsNull(str2, string.Empty)))
                return true;

            if (IsNull(str1, string.Empty).ToLower().Trim() == IsNull(str2, string.Empty).ToLower().Trim())
                return true;
            else
                return false;
        }

        public static string IsNull(object values, string vdefault)
        {
            if (values != null && values != DBNull.Value)
                return Convert.ToString(values);
            else
                return vdefault;
        }

        public static Int32 IsNull(object values, Int32 vdefault)
        {
            if (values != null && values != DBNull.Value)
            {
                if (string.IsNullOrEmpty(values.ToString()))
                    values = 0;

                return Convert.ToInt32(values);
            }
            else
                return vdefault;
        }

        public static string PsgGuid
        {
            get
            {
                Random random = new Random();
                return "_" + Guid.NewGuid().ToString().Substring(0, 7).ToUpper() + random.Next(100).ToString();
            }
        }

        public static string GetFilters(string beginString, object[] param, int i)
        {
            string rez = string.Empty;

            if (param.Length <= i)
                rez = "";
            else
            {
                string filters = param[i].ToString();
                string tmp = filters.Replace("'", "");

                if (!string.IsNullOrEmpty(tmp))
                    rez = tmp.ToString().Replace("*", "'");
                else
                    rez = string.Empty;
            }

            if (!string.IsNullOrEmpty(rez))
                rez = beginString + rez;

            return rez;
        }

        public static string GetFilters(string beginString, string fieldKey, string valueKey, object[] param, int i)
        {
            string filterID;
            string rez = string.Empty;

            if (valueKey.Contains("null"))
                filterID = "";
            else
                filterID = string.Format(" {0} =  {1} ", fieldKey, valueKey);

            if (param.Length <= i)
                rez = filterID;
            else
            {
                string filters = param[i].ToString();
                string tmp = filters.Replace("'", "");

                if (!string.IsNullOrEmpty(tmp))
                    rez = filterID + tmp.ToString().Replace("*", "'");
                else
                    rez = filterID;
            }

            if (!string.IsNullOrEmpty(rez))
                rez = beginString + rez;

            return rez;
        }

        public static void LoadView(SqlConnection sqlcon, string selectCmd, ref DataTable dt)
        {
            try
            {
                Utils.server.smsg(selectCmd);
                sqlcon.Open();
                Utils.LoadDataTable(sqlcon, dt, selectCmd);
            }
            catch (Exception ex)
            {
                server.smsg(ex.Message);
            }
            finally
            {
                sqlcon.Close();
            }
        }

        public static DataTable RunSelect(SqlConnection sqlcon, string selectCmd)
        {
            DataTable dt = new DataTable();
            try
            {
                Utils.server.smsg(selectCmd);
                sqlcon.Open();
                Utils.LoadDataTable(sqlcon, dt, selectCmd);
            }
            catch (Exception ex)
            {
                server.smsg(ex.Message);
            }
            finally
            {
                sqlcon.Close();
            }

            return dt;
        }

        public static void LoadDataTable(SqlConnection sqlcon, DataTable dt, string cmd)
        {
            sqlcon.sqlcommand = cmd;
            sqlcon.cmd.CommandText = sqlcon.sqlcommand;
            sqlcon.adapter.SelectCommand = sqlcon.cmd;
            sqlcon.adapter.SelectCommand.Connection = sqlcon.conn;
            sqlcon.adapter.Fill(dt);
        }

        public static void LoadDataSet(SqlConnection sqlcon, DataSet ds, string cmd, string localTableName)
        {
            server.smsg(cmd);
            sqlcon.sqlcommand = cmd;
            sqlcon.cmd.CommandText = sqlcon.sqlcommand;
            sqlcon.adapter.SelectCommand = sqlcon.cmd;
            sqlcon.adapter.SelectCommand.Connection = sqlcon.conn;
            sqlcon.adapter.Fill(ds, localTableName);
        }

        public static void SaveDataSet(SqlConnection sqlcon, DataSet ds, string localTableName, string serverTableName, Dictionary<string, string> mapColumns)
        {
            if (ds.Tables[localTableName].Rows.Count == 0)
                return;

            ds = ds.Copy();

            DataTable dt = new DataTable();
            sqlcon.cmd.CommandText = "select * from " + serverTableName + " where 1=2 ";
            sqlcon.adapter.SelectCommand = sqlcon.cmd;
            sqlcon.adapter.SelectCommand.Connection = sqlcon.conn;
            sqlcon.adapter.Fill(dt);

            if (dt != null && dt.Columns.Count > 0)
            {
                string colsel = string.Empty;
                foreach (DataColumn col in dt.Columns)
                {
                    if (ds.Tables[localTableName].Columns.Contains(col.ColumnName))
                        colsel = colsel + col.ColumnName + ",";

                    if (mapColumns.ContainsKey(col.ColumnName))
                        colsel = colsel + col.ColumnName + " as " + mapColumns[col.ColumnName] + ",";
                }

                colsel = colsel.Substring(0, colsel.Length - 1);
                sqlcon.cmd.CommandText = " select " + colsel + " from " + serverTableName + " where 1=2 ";
                sqlcon.adapter.SelectCommand = sqlcon.cmd;
                sqlcon.adapter.SelectCommand.Connection = sqlcon.conn;
                new OdbcCommandBuilder(sqlcon.adapter);

                sqlcon.adapter.Update(ds, localTableName);
            }
        }

        public static void SaveDataSet(SqlConnection sqlcon, DataSet ds, string localTableName, string serverTableName)
        {
            if (ds.Tables[localTableName].Rows.Count == 0)
                return;

            ds = ds.Copy();

            DataTable dt = new DataTable();
            sqlcon.cmd.CommandText = "select * from " + serverTableName + " where 1=2 ";
            sqlcon.adapter.SelectCommand = sqlcon.cmd;
            sqlcon.adapter.SelectCommand.Connection = sqlcon.conn;
            sqlcon.adapter.Fill(dt);

            if (dt != null && dt.Columns.Count > 0)
            {
                string colsel = string.Empty;
                foreach (DataColumn col in dt.Columns)
                    if (ds.Tables[localTableName].Columns.Contains(col.ColumnName))
                        colsel = colsel + col.ColumnName + ",";

                colsel = colsel.Substring(0, colsel.Length - 1);
                sqlcon.cmd.CommandText = " select " + colsel + " from " + serverTableName + " where 1=2 ";
                sqlcon.adapter.SelectCommand = sqlcon.cmd;
                sqlcon.adapter.SelectCommand.Connection = sqlcon.conn;
                new OdbcCommandBuilder(sqlcon.adapter);

                sqlcon.adapter.Update(ds, localTableName);
            }
        }
    }
}
